@extends('admin.layout')

@php
$selLang = \App\Language::where('code', request()->input('language'))->first();
@endphp
@if(!empty($selLang) && $selLang->rtl == 1)
@section('styles')
<style>
  form:not(.modal-form) input,
  form:not(.modal-form) textarea,
  form:not(.modal-form) select,
  select[name='language'] {
    direction: rtl;
  }

  form:not(.modal-form) .note-editor.note-frame .note-editing-area .note-editable {
    direction: rtl;
    text-align: right;
  }
</style>
@endsection
@endif

@section('content')
<div class="page-header">
  <h4 class="page-title">Faqs</h4>
  <ul class="breadcrumbs">
    <li class="nav-home">
      <a href="{{route('admin.dashboard')}}">
        <i class="flaticon-home"></i>
      </a>
    </li>
    <li class="separator">
      <i class="flaticon-right-arrow"></i>
    </li>
    <li class="nav-item">
      <a href="#">Home Page</a>
    </li>
    <li class="separator">
      <i class="flaticon-right-arrow"></i>
    </li>
    <li class="nav-item">
      <a href="#">Faqs</a>
    </li>
  </ul>
</div>
<div class="row">
  <div class="col-md-12">

    <div class="card">
      <div class="card-header">
        <div class="row">
          <div class="col-lg-4">
            <div class="card-title d-inline-block">Faqs</div>
          </div>
          <div class="col-lg-3">
            @if (!empty($langs))
            <select name="language" class="form-control"
              onchange="window.location='{{url()->current() . '?language='}}'+this.value">
              <option value="" selected disabled>Select a Language</option>
              @foreach ($langs as $lang)
              <option value="{{$lang->code}}" {{$lang->code == request()->input('language') ? 'selected' : ''}}>
                {{$lang->name}}</option>
              @endforeach
            </select>
            @endif
          </div>
          <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
            <a href="#" class="btn btn-primary float-right btn-sm" data-toggle="modal" data-target="#createModal"><i
                class="fas fa-plus"></i> Add Faq</a>
            <button class="btn btn-danger float-right btn-sm mr-2 d-none bulk-delete"
              data-href="{{route('admin.faq.bulk.delete')}}"><i class="flaticon-interface-5"></i> Delete</button>
          </div>
        </div>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-lg-12">
            @if (count($faqs) == 0)
            <h3 class="text-center">NO FAQ FOUND</h3>
            @else
            <div class="table-responsive">
              <table class="table table-striped mt-3" id="basic-datatables">
                <thead>
                  <tr>
                    <th scope="col">
                      <input type="checkbox" class="bulk-check" data-val="all">
                    </th>
                    <th scope="col">Question</th>
                    <th scope="col">Serial Number</th>
                    <th scope="col">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($faqs as $key => $faq)
                  <tr>
                    <td>
                      <input type="checkbox" class="bulk-check" data-val="{{$faq->id}}">
                    </td>
                    <td>
                      {{convertUtf8(strlen($faq->question)) > 50 ? convertUtf8(substr($faq->question, 0, 50)) . '...' : convertUtf8($faq->question)}}
                    </td>
                    <td>{{$faq->serial_number}}</td>
                    <td>
                      <a class="btn btn-secondary btn-sm editbtn" href="#editModal" data-toggle="modal"
                        data-faq_id="{{$faq->id}}" data-category_id="{{ $faq->category_id }}" data-question="{{$faq->question}}" data-answer="{{$faq->answer}}"
                        data-serial_number="{{$faq->serial_number}}">
                        <span class="btn-label">
                          <i class="fas fa-edit"></i>
                        </span>
                        Edit
                      </a>
                      <form class="deleteform d-inline-block" action="{{route('admin.faq.delete')}}" method="post">
                        @csrf
                        <input type="hidden" name="faq_id" value="{{$faq->id}}">
                        <button type="submit" class="btn btn-danger btn-sm deletebtn">
                          <span class="btn-label">
                            <i class="fas fa-trash"></i>
                          </span>
                          Delete
                        </button>
                      </form>
                    </td>
                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Create Faq Modal -->
<div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
  aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">Add Faq</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="ajaxForm" class="modal-form create" action="{{route('admin.faq.store')}}" method="POST">
          @csrf
          <div class="form-group">
            <label for="">Language **</label>
            <select name="language_id" class="form-control">
              <option value="" selected disabled>Select a language</option>
              @foreach ($langs as $lang)
              <option value="{{$lang->id}}">{{$lang->name}}</option>
              @endforeach
            </select>
            <p id="errlanguage_id" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group {{ $categoryInfo->faq_category_status == 0 ? 'd-none' : '' }}">
            <label for="">Category **</label>
            <select name="category_id" id="faq_category_id" class="form-control" disabled>
              <option selected disabled>Select a category</option>
            </select>
            <p id="errcategory_id" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group">
            <label for="">Question **</label>
            <input type="text" class="form-control" name="question" value="" placeholder="Enter question">
            <p id="errquestion" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group">
            <label for="">Answer **</label>
            <textarea class="form-control" name="answer" rows="5" cols="80" placeholder="Enter answer"></textarea>
            <p id="erranswer" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group">
            <label for="">Serial Number **</label>
            <input type="number" class="form-control ltr" name="serial_number" value=""
              placeholder="Enter Serial Number">
            <p id="errserial_number" class="mb-0 text-danger em"></p>
            <p class="text-warning"><small>The higher the serial number is, the later the FAQ will be shown.</small></p>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button id="submitBtn" type="button" class="btn btn-primary">Submit</button>
      </div>
    </div>
  </div>
</div>

<!-- Edit Faq Modal -->
<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
  aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">Edit Faq</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="ajaxEditForm" class="" action="{{route('admin.faq.update')}}" method="POST">
          @csrf
          <input id="infaq_id" type="hidden" name="faq_id" value="">
          <div class="form-group {{ $categoryInfo->faq_category_status == 0 ? 'd-none' : '' }}">
            <label for="">Category **</label>
            <select name="category_id" id="incategory_id" class="form-control">
              <option disabled>Select a category</option>
              @foreach ($categories as $category)
                <option value="{{ $category->id }}">{{ $category->name }}</option>
              @endforeach
            </select>
            <p id="eerrcategory_id" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group">
            <label for="">Question **</label>
            <input id="inquestion" type="text" class="form-control" name="question" value=""
              placeholder="Enter question">
            <p id="eerrquestion" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group">
            <label for="">Answer **</label>
            <textarea id="inanswer" class="form-control" name="answer" rows="5" cols="80"
              placeholder="Enter answer"></textarea>
            <p id="eerranswer" class="mb-0 text-danger em"></p>
          </div>
          <div class="form-group">
            <label for="">Serial Number **</label>
            <input id="inserial_number" type="number" class="form-control ltr" name="serial_number" value=""
              placeholder="Enter Serial Number">
            <p id="eerrserial_number" class="mb-0 text-danger em"></p>
            <p class="text-warning"><small>The higher the serial number is, the later the FAQ will be shown.</small></p>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button id="updateBtn" type="button" class="btn btn-primary">Save Changes</button>
      </div>
    </div>
  </div>
</div>
@endsection

@section('scripts')
<script>
  $(document).ready(function() {
    $("select[name='language_id']").on('change', function() {
      $("#faq_category_id").removeAttr('disabled');

      let langId = $(this).val();
      let url = "{{url('/')}}/admin/faq/" + langId + "/get_categories";

      $.get(url, function(data) {
        let options = `<option value="" disabled selected>Select a category</option>`;

        if (data.length == 0) {
          options += `<option value="" disabled>${'No Category Exists'}</option>`;
        } else {
          for (let i = 0; i < data.length; i++) {
            options +=`<option value="${data[i].id}">${data[i].name}</option>`;
          }
        }

        $("#faq_category_id").html(options);
      });
    });

    // make input fields RTL
    $("select[name='language_id']").on('change', function() {
      $(".request-loader").addClass("show");
      let url = "{{url('/')}}/admin/rtlcheck/" + $(this).val();
      console.log(url);
      $.get(url, function(data) {
        $(".request-loader").removeClass("show");
        if (data == 1) {
          $("form.create input").each(function() {
            if (!$(this).hasClass('ltr')) {
              $(this).addClass('rtl');
            }
          });
          $("form.create select").each(function() {
            if (!$(this).hasClass('ltr')) {
              $(this).addClass('rtl');
            }
          });
          $("form.create textarea").each(function() {
            if (!$(this).hasClass('ltr')) {
              $(this).addClass('rtl');
            }
          });
          $("form.create .nicEdit-main").each(function() {
            $(this).addClass('rtl text-right');
          });
        } else {
          $("form.create input, form.create select, form.create textarea").removeClass('rtl');
          $("form.create .nicEdit-main").removeClass('rtl text-right');
        }
      })
    });
  });
</script>
@endsection
