<?php

use Illuminate\Support\Facades\Route;


use App\Http\Controllers\Admin\CommentController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\DashboardController as DashboardControllerForAdmin;
use App\Http\Controllers\Admin\DynamicPageController;
use App\Http\Controllers\Admin\EmailTemplateController;
use App\Http\Controllers\Admin\FooterColumnController;
use App\Http\Controllers\Admin\GeneralSettingController;
use App\Http\Controllers\Admin\LoginController as LoginControllerForAdmin;
use App\Http\Controllers\Admin\LogoutController as LogoutControllerForAdmin;
use App\Http\Controllers\Admin\ForgetPasswordController as ForgetPasswordControllerForAdmin;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\PageAboutController;
use App\Http\Controllers\Admin\PageBlogController;
use App\Http\Controllers\Admin\PageCareerController;
use App\Http\Controllers\Admin\PageContactController;
use App\Http\Controllers\Admin\PageFaqController;
use App\Http\Controllers\Admin\PageHomeController;
use App\Http\Controllers\Admin\PageOtherController;
use App\Http\Controllers\Admin\PagePhotoGalleryController;
use App\Http\Controllers\Admin\PagePrivacyController;
use App\Http\Controllers\Admin\PageProjectController;
use App\Http\Controllers\Admin\PageServiceController;
use App\Http\Controllers\Admin\PageShopController;
use App\Http\Controllers\Admin\PageTeamController;
use App\Http\Controllers\Admin\PageTermController;
use App\Http\Controllers\Admin\PageVideoGalleryController;
use App\Http\Controllers\Admin\PhotoChangeController;
use App\Http\Controllers\Admin\PhotoController;
use App\Http\Controllers\Admin\ResetPasswordController as ResetPasswordControllerForAdmin;
use App\Http\Controllers\Admin\PasswordChangeController as PasswordChangeControllerForAdmin;
use App\Http\Controllers\Admin\ProfileChangeController as ProfileChangeControllerForAdmin;
use App\Http\Controllers\Admin\CategoryController as CategoryControllerForAdmin;
use App\Http\Controllers\Admin\BlogController as BlogControllerForAdmin;
use App\Http\Controllers\Admin\ProjectController as ProjectControllerForAdmin;
use App\Http\Controllers\Admin\ServiceController as ServiceControllerForAdmin;
use App\Http\Controllers\Admin\ShippingController;
use App\Http\Controllers\Admin\SocialMediaItemController;
use App\Http\Controllers\Admin\SubscriberController;
use App\Http\Controllers\Admin\TeamMemberController as TeamMemberControllerForAdmin;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\VideoController;
use App\Http\Controllers\Admin\WhyChooseController;
use App\Http\Controllers\Admin\JobController as JobControllerForAdmin;
use App\Http\Controllers\Admin\FaqController as FaqControllerForAdmin;
use App\Http\Controllers\Admin\ProductController as ProductControllerForAdmin;
use App\Http\Controllers\Admin\OrderController as OrderControllerForAdmin;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\TranslationController;

use App\Http\Controllers\Customer\CheckoutController;
use App\Http\Controllers\Customer\DashboardController as DashboardControllerForCustomer;
use App\Http\Controllers\Customer\ForgetPasswordController as ForgetPasswordControllerForCustomer;
use App\Http\Controllers\Customer\LoginController as LoginControllerForCustomer;
use App\Http\Controllers\Customer\LogoutController as LogoutControllerForCustomer;
use App\Http\Controllers\Customer\OrderController as OrderControllerForCustomer;
use App\Http\Controllers\Customer\PasswordChangeController as PasswordChangeControllerForCustomer;
use App\Http\Controllers\Customer\ProfileChangeController as ProfileChangeControllerForCustomer;
use App\Http\Controllers\Customer\RegistrationController;
use App\Http\Controllers\Customer\ResetPasswordController as ResetPasswordControllerForCustomer;

use App\Http\Controllers\Front\AboutController;
use App\Http\Controllers\Front\BlogController as BlogControllerForFront;
use App\Http\Controllers\Front\CategoryController as CategoryControllerForFront;
use App\Http\Controllers\Front\ContactController;
use App\Http\Controllers\Front\FaqController as FaqControllerForFront;
use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Front\JobController as JobControllerForFront;
use App\Http\Controllers\Front\PageController;
use App\Http\Controllers\Front\PhotoGalleryController;
use App\Http\Controllers\Front\PrivacyController;
use App\Http\Controllers\Front\ProductController as ProductControllerForFront;
use App\Http\Controllers\Front\ProjectController as ProjectControllerForFront;
use App\Http\Controllers\Front\SearchController;
use App\Http\Controllers\Front\ServiceController as ServiceControllerForFront;
use App\Http\Controllers\Front\SubscriptionController;
use App\Http\Controllers\Front\TeamMemberController as TeamMemberControllerForFront;
use App\Http\Controllers\Front\TermController;
use App\Http\Controllers\Front\VideoGalleryController;


Route::get('/', [HomeController::class,'index']);
Route::get('about', [AboutController::class,'index'])->name('front.about');
Route::get('services', [ServiceControllerForFront::class,'index'])->name('front.services');
Route::get('service/{slug}', [ServiceControllerForFront::class,'detail']);
Route::get('blog', [BlogControllerForFront::class,'index'])->name('front.blogs');
Route::get('blog/{slug}', [BlogControllerForFront::class,'detail']);
Route::post('blog/comment', [BlogControllerForFront::class,'comment'])->name('front.comment');
Route::get('category/{slug}', [CategoryControllerForFront::class,'detail']);
Route::post('search', [SearchController::class,'index']);
Route::get('search', function() {abort(404);});
Route::get('projects', [ProjectControllerForFront::class,'index'])->name('front.projects');
Route::get('project/{slug}', [ProjectControllerForFront::class,'detail']);
Route::get('faq', [FaqControllerForFront::class,'index'])->name('front.faq');
Route::get('team-members', [TeamMemberControllerForFront::class,'index'])->name('front.team_members');
Route::get('team-member/{slug}', [TeamMemberControllerForFront::class,'detail']);
Route::get('photo-gallery', [PhotoGalleryController::class,'index'])->name('front.photo_gallery');
Route::get('video-gallery', [VideoGalleryController::class,'index'])->name('front.video_gallery');
Route::get('page/{slug}', [PageController::class,'detail']);
Route::get('contact', [ContactController::class,'index'])->name('front.contact');
Route::post('contact/store', [ContactController::class,'send_email'])->name('front.contact_form');
Route::get('career', [JobControllerForFront::class,'index'])->name('front.career');
Route::get('job/{slug}', [JobControllerForFront::class,'detail']);
Route::get('job/apply/{slug}', [JobControllerForFront::class,'apply']);
Route::post('job/apply/store', [JobControllerForFront::class,'apply_form'])->name('front.apply_form');
Route::get('shop', [ProductControllerForFront::class,'index'])->name('front.shop');
Route::get('product/{slug}', [ProductControllerForFront::class,'detail']);
Route::post('product/cart/add', [ProductControllerForFront::class,'add_to_cart'])->name('front.add_to_cart');
Route::get('cart', [ProductControllerForFront::class,'cart'])->name('front.cart');
Route::get('cart/delete/{id}', [ProductControllerForFront::class,'cart_item_delete']);
Route::post('cart/update', [ProductControllerForFront::class,'update_cart']);
Route::get('checkout', [ProductControllerForFront::class,'checkout'])->name('front.checkout');
Route::post('checkout/shipping/update', [ProductControllerForFront::class,'shipping_update'])->name('front.shipping_update');
Route::post('checkout/coupon/update', [ProductControllerForFront::class,'coupon_update'])->name('front.coupon_update');
Route::post('subscription', [SubscriptionController::class,'index'])->name('front.subscription');
Route::get('subscriber/verify/{token}/{email}', [SubscriptionController::class,'verify']);
Route::get('terms-and-conditions', [TermController::class,'index'])->name('front.term');
Route::get('privacy-policy', [PrivacyController::class,'index'])->name('front.privacy');


// Customer - No middleware
Route::prefix('customer')->group(function () {
    Route::get('login', [LoginControllerForCustomer::class,'index'])->name('customer.login');
    Route::post('login/store', [LoginControllerForCustomer::class,'store'])->name('customer.login.store');
    Route::get('logout', [LogoutControllerForCustomer::class,'index'])->name('customer.logout');
    Route::get('register', [RegistrationController::class,'index'])->name('customer.registration');
    Route::post('registration/store', [RegistrationController::class,'store'])->name('customer.registration.store');
    Route::get('registration/verify/{token}/{email}', [RegistrationController::class,'verify']);
    Route::get('forget-password', [ForgetPasswordControllerForCustomer::class,'index'])->name('customer.forget_password');
    Route::post('forget-password/store', [ForgetPasswordControllerForCustomer::class,'store'])->name('customer.forget_password.store');
    Route::get('reset-password/{token}/{email}', [ResetPasswordControllerForCustomer::class,'index']);
    Route::post('reset-password/update', [ResetPasswordControllerForCustomer::class,'update']);
    Route::post('checkout/billing/shipping', [CheckoutController::class,'billing_shipping'])->name('customer.billing_shipping_submit');
    Route::get('payment', [CheckoutController::class,'payment'])->name('customer.payment');
    Route::post('payment/stripe', [CheckoutController::class,'stripe'])->name('customer.stripe');
    Route::get('stripe/success', [CheckoutController::class, 'stripe_success'])->name('customer.stripe.success');
    Route::get('stripe/cancel', [CheckoutController::class, 'stripe_cancel'])->name('customer.stripe.cancel');
    Route::post('payment/paypal', [CheckoutController::class,'paypal'])->name('customer.paypal');
    Route::get('paypal/success', [CheckoutController::class, 'paypal_success'])->name('customer.paypal.success');
    Route::get('paypal/cancel', [CheckoutController::class, 'paypal_cancel'])->name('customer.paypal.cancel');
    Route::post('checkout/login/store', [CheckoutController::class,'login'])->name('customer.login_from_checkout_page.store');
});


// Customer - With middleware
Route::middleware('auth')->prefix('customer')->group(function () {
    Route::get('dashboard', [DashboardControllerForCustomer::class,'index'])->name('customer.dashboard');
    Route::get('password-change', [PasswordChangeControllerForCustomer::class,'index'])->name('customer.password_change');
    Route::post('password-change/update', [PasswordChangeControllerForCustomer::class,'update']);
    Route::get('profile-change', [ProfileChangeControllerForCustomer::class,'index'])->name('customer.profile_change');
    Route::post('profile-change/update', [ProfileChangeControllerForCustomer::class,'update']);
    Route::get('order', [OrderControllerForCustomer::class,'index'])->name('customer.order');
});


Route::get('admin', function () {return redirect('admin/login');});

// Admin - No middleware
Route::prefix('admin')->group(function () {
    Route::get('login', [LoginControllerForAdmin::class,'index'])->name('admin.login');
    Route::post('login/store', [LoginControllerForAdmin::class,'store'])->name('admin.login.store');
    Route::get('logout', [LogoutControllerForAdmin::class,'index'])->name('admin.logout');
    Route::get('forget-password', [ForgetPasswordControllerForAdmin::class,'index'])->name('admin.forget_password');
    Route::post('forget-password/store', [ForgetPasswordControllerForAdmin::class,'store'])->name('admin.forget_password.store');
    Route::get('reset-password/{token}/{email}', [ResetPasswordControllerForAdmin::class,'index']);
    Route::post('reset-password/update', [ResetPasswordControllerForAdmin::class,'update']);
});

// Admin - With middleware
Route::middleware('admin')->prefix('admin')->group(function () {
    Route::get('dashboard', [DashboardControllerForAdmin::class,'index'])->name('admin.dashboard');
    Route::get('password-change', [PasswordChangeControllerForAdmin::class,'index'])->name('admin.password_change');
    Route::post('password-change/update', [PasswordChangeControllerForAdmin::class,'update']);
    Route::get('profile-change', [ProfileChangeControllerForAdmin::class,'index'])->name('admin.profile_change');
    Route::post('profile-change/update', [ProfileChangeControllerForAdmin::class,'update']);
    Route::get('photo-change', [PhotoChangeController::class,'index'])->name('admin.photo_change');
    Route::post('photo-change/update', [PhotoChangeController::class,'update']);

    Route::get('category/view', [CategoryControllerForAdmin::class,'index'])->name('admin.category.index');
    Route::get('category/create', [CategoryControllerForAdmin::class,'create'])->name('admin.category.create');
    Route::post('category/store', [CategoryControllerForAdmin::class,'store'])->name('admin.category.store');
    Route::get('category/delete/{id}', [CategoryControllerForAdmin::class,'destroy']);
    Route::get('category/edit/{id}', [CategoryControllerForAdmin::class,'edit']);
    Route::post('category/update/{id}', [CategoryControllerForAdmin::class,'update']);

    Route::get('blog/view', [BlogControllerForAdmin::class,'index'])->name('admin.blog.index');
    Route::get('blog/create', [BlogControllerForAdmin::class,'create'])->name('admin.blog.create');
    Route::post('blog/store', [BlogControllerForAdmin::class,'store'])->name('admin.blog.store');
    Route::get('blog/delete/{id}', [BlogControllerForAdmin::class,'destroy']);
    Route::get('blog/edit/{id}', [BlogControllerForAdmin::class,'edit']);
    Route::post('blog/update/{id}', [BlogControllerForAdmin::class,'update']);

    Route::get('comment/approved', [CommentController::class,'approved'])->name('admin.comment.approved');
    Route::get('comment/make-pending/{id}', [CommentController::class,'make_pending']);
    Route::get('comment/pending', [CommentController::class,'pending'])->name('admin.comment.pending');
    Route::get('comment/make-approved/{id}', [CommentController::class,'make_approved']);
    Route::get('comment/delete/{id}', [CommentController::class,'destroy']);

    Route::get('slider/view', [SliderController::class,'index'])->name('admin.slider.index');
    Route::get('slider/create', [SliderController::class,'create'])->name('admin.slider.create');
    Route::post('slider/store', [SliderController::class,'store'])->name('admin.slider.store');
    Route::get('slider/delete/{id}', [SliderController::class,'destroy']);
    Route::get('slider/edit/{id}', [SliderController::class,'edit']);
    Route::post('slider/update/{id}', [SliderController::class,'update']);

    Route::get('setting/general/logo/edit', [GeneralSettingController::class,'logo_edit'])->name('admin.general_setting.logo');
    Route::post('setting/general/logo/update', [GeneralSettingController::class,'logo_update']);

    Route::get('setting/general/favicon/edit', [GeneralSettingController::class,'favicon_edit'])->name('admin.general_setting.favicon');
    Route::post('setting/general/favicon/update', [GeneralSettingController::class,'favicon_update']);

    Route::get('setting/general/loginbg/edit', [GeneralSettingController::class,'loginbg_edit'])->name('admin.general_setting.loginbg');
    Route::post('setting/general/loginbg/update', [GeneralSettingController::class,'loginbg_update']);

    Route::get('setting/general/topbar/edit', [GeneralSettingController::class,'topbar_edit'])->name('admin.general_setting.topbar');
    Route::post('setting/general/topbar/update', [GeneralSettingController::class,'topbar_update']);

    Route::get('setting/general/banner/edit', [GeneralSettingController::class,'banner_edit'])->name('admin.general_setting.banner');
    Route::post('setting/general/banner/update', [GeneralSettingController::class,'banner_update']);

    Route::get('setting/general/footer/edit', [GeneralSettingController::class,'footer_edit'])->name('admin.general_setting.footer');
    Route::post('setting/general/footer/update', [GeneralSettingController::class,'footer_update']);

    Route::get('setting/general/sidebar/edit', [GeneralSettingController::class,'sidebar_edit'])->name('admin.general_setting.sidebar');
    Route::post('setting/general/sidebar/update', [GeneralSettingController::class,'sidebar_update']);

    Route::get('setting/general/color/edit', [GeneralSettingController::class,'color_edit'])->name('admin.general_setting.color');
    Route::post('setting/general/color/update', [GeneralSettingController::class,'color_update']);

    Route::get('setting/general/preloader/edit', [GeneralSettingController::class,'preloader_edit'])->name('admin.general_setting.preloader');
    Route::post('setting/general/preloader/update', [GeneralSettingController::class,'preloader_update']);

    Route::get('setting/general/stickyheader/edit', [GeneralSettingController::class,'stickyheader_edit'])->name('admin.general_setting.stickyheader');
    Route::post('setting/general/stickyheader/update', [GeneralSettingController::class,'stickyheader_update']);

    Route::get('setting/general/googleanalytic/edit', [GeneralSettingController::class,'googleanalytic_edit'])->name('admin.general_setting.googleanalytic');
    Route::post('setting/general/googleanalytic/update', [GeneralSettingController::class,'googleanalytic_update']);

    Route::get('setting/general/googlerecaptcha/edit', [GeneralSettingController::class,'googlerecaptcha_edit'])->name('admin.general_setting.googlerecaptcha');
    Route::post('setting/general/googlerecaptcha/update', [GeneralSettingController::class,'googlerecaptcha_update']);

    Route::get('setting/general/tawklivechat/edit', [GeneralSettingController::class,'tawklivechat_edit'])->name('admin.general_setting.tawklivechat');
    Route::post('setting/general/tawklivechat/update', [GeneralSettingController::class,'tawklivechat_update']);

    Route::get('setting/general/cookieconsent/edit', [GeneralSettingController::class,'cookieconsent_edit'])->name('admin.general_setting.cookieconsent');
    Route::post('setting/general/cookieconsent/update', [GeneralSettingController::class,'cookieconsent_update']);

    Route::get('page/home/edit', [PageHomeController::class,'edit'])->name('admin.page_home.edit');
    Route::post('page/home/1', [PageHomeController::class,'update1']);
    Route::post('page/home/2', [PageHomeController::class,'update2']);
    Route::post('page/home/3', [PageHomeController::class,'update3']);
    Route::post('page/home/4', [PageHomeController::class,'update4']);
    Route::post('page/home/5', [PageHomeController::class,'update5']);
    Route::post('page/home/6', [PageHomeController::class,'update6']);
    Route::post('page/home/7', [PageHomeController::class,'update7']);
    Route::post('page/home/8', [PageHomeController::class,'update8']);
    Route::post('page/home/9', [PageHomeController::class,'update9']);
    Route::post('page/home/10', [PageHomeController::class,'update10']);

    Route::get('page/about/edit', [PageAboutController::class,'edit'])->name('admin.page_about.edit');
    Route::post('page/about/update', [PageAboutController::class,'update']);

    Route::get('page/service/edit', [PageServiceController::class,'edit'])->name('admin.page_service.edit');
    Route::post('page/service/update', [PageServiceController::class,'update']);

    Route::get('page/shop/edit', [PageShopController::class,'edit'])->name('admin.page_shop.edit');
    Route::post('page/shop/update', [PageShopController::class,'update']);

    Route::get('page/blog/edit', [PageBlogController::class,'edit'])->name('admin.page_blog.edit');
    Route::post('page/blog/update', [PageBlogController::class,'update']);

    Route::get('page/project/edit', [PageProjectController::class,'edit'])->name('admin.page_project.edit');
    Route::post('page/project/update', [PageProjectController::class,'update']);

    Route::get('page/faq/edit', [PageFaqController::class,'edit'])->name('admin.page_faq.edit');
    Route::post('page/faq/update', [PageFaqController::class,'update']);

    Route::get('page/team/edit', [PageTeamController::class,'edit'])->name('admin.page_team.edit');
    Route::post('page/team/update', [PageTeamController::class,'update']);

    Route::get('page/photo-gallery/edit', [PagePhotoGalleryController::class,'edit'])->name('admin.page_photo_gallery.edit');
    Route::post('page/photo-gallery/update', [PagePhotoGalleryController::class,'update']);

    Route::get('page/video-gallery/edit', [PageVideoGalleryController::class,'edit'])->name('admin.page_video_gallery.edit');
    Route::post('page/video-gallery/update', [PageVideoGalleryController::class,'update']);

    Route::get('page/contact/edit', [PageContactController::class,'edit'])->name('admin.page_contact.edit');
    Route::post('page/contact/update', [PageContactController::class,'update']);

    Route::get('page/career/edit', [PageCareerController::class,'edit'])->name('admin.page_career.edit');
    Route::post('page/career/update', [PageCareerController::class,'update']);

    Route::get('page/term/edit', [PageTermController::class,'edit'])->name('admin.page_term.edit');
    Route::post('page/term/update', [PageTermController::class,'update']);

    Route::get('page/privacy/edit', [PagePrivacyController::class,'edit'])->name('admin.page_privacy.edit');
    Route::post('page/privacy/update', [PagePrivacyController::class,'update']);

    Route::get('page/other/edit', [PageOtherController::class,'edit'])->name('admin.page_other.edit');
    Route::post('page/other/1', [PageOtherController::class,'update1']);
    Route::post('page/other/2', [PageOtherController::class,'update2']);
    Route::post('page/other/3', [PageOtherController::class,'update3']);
    Route::post('page/other/4', [PageOtherController::class,'update4']);
    Route::post('page/other/5', [PageOtherController::class,'update5']);
    Route::post('page/other/6', [PageOtherController::class,'update6']);
    Route::post('page/other/7', [PageOtherController::class,'update7']);
    Route::post('page/other/8', [PageOtherController::class,'update8']);

    Route::get('dynamic-page/view', [DynamicPageController::class,'index'])->name('admin.dynamic_page.index');
    Route::get('dynamic-page/create', [DynamicPageController::class,'create'])->name('admin.dynamic_page.create');
    Route::post('dynamic-page/store', [DynamicPageController::class,'store'])->name('admin.dynamic_page.store');
    Route::get('dynamic-page/delete/{id}', [DynamicPageController::class,'destroy']);
    Route::get('dynamic-page/edit/{id}', [DynamicPageController::class,'edit']);
    Route::post('dynamic-page/update/{id}', [DynamicPageController::class,'update']);

    Route::get('project/view', [ProjectControllerForAdmin::class,'index'])->name('admin.project.index');
    Route::get('project/create', [ProjectControllerForAdmin::class,'create'])->name('admin.project.create');
    Route::post('project/store', [ProjectControllerForAdmin::class,'store'])->name('admin.project.store');
    Route::get('project/delete/{id}', [ProjectControllerForAdmin::class,'destroy']);
    Route::get('project/edit/{id}', [ProjectControllerForAdmin::class,'edit']);
    Route::post('project/update/{id}', [ProjectControllerForAdmin::class,'update']);
    Route::get('project/gallery/{id}', [ProjectControllerForAdmin::class,'gallerysection']);
    Route::get('project/gallery-delete/{id}', [ProjectControllerForAdmin::class,'gallerydelete']);
    Route::post('project/gallery-store', [ProjectControllerForAdmin::class,'gallerystore'])->name('admin.project.gallery-store');

    Route::get('photo-gallery/view', [PhotoController::class,'index'])->name('admin.photo.index');
    Route::get('photo-gallery/create', [PhotoController::class,'create'])->name('admin.photo.create');
    Route::post('photo-gallery/store', [PhotoController::class,'store'])->name('admin.photo.store');
    Route::get('photo-gallery/delete/{id}', [PhotoController::class,'destroy']);
    Route::get('photo-gallery/edit/{id}', [PhotoController::class,'edit']);
    Route::post('photo-gallery/update/{id}', [PhotoController::class,'update']);

    Route::get('video-gallery/view', [VideoController::class,'index'])->name('admin.video.index');
    Route::get('video-gallery/create', [VideoController::class,'create'])->name('admin.video.create');
    Route::post('video-gallery/store', [VideoController::class,'store'])->name('admin.video.store');
    Route::get('video-gallery/delete/{id}', [VideoController::class,'destroy']);
    Route::get('video-gallery/edit/{id}', [VideoController::class,'edit']);
    Route::post('video-gallery/update/{id}', [VideoController::class,'update']);

    Route::get('why-choose/view', [WhyChooseController::class,'index'])->name('admin.why_choose.index');
    Route::get('why-choose/create', [WhyChooseController::class,'create'])->name('admin.why_choose.create');
    Route::post('why-choose/store', [WhyChooseController::class,'store'])->name('admin.why_choose.store');
    Route::get('why-choose/delete/{id}', [WhyChooseController::class,'destroy']);
    Route::get('why-choose/edit/{id}', [WhyChooseController::class,'edit']);
    Route::post('why-choose/update/{id}', [WhyChooseController::class,'update']);

    Route::get('service/view', [ServiceControllerForAdmin::class,'index'])->name('admin.service.index');
    Route::get('service/create', [ServiceControllerForAdmin::class,'create'])->name('admin.service.create');
    Route::post('service/store', [ServiceControllerForAdmin::class,'store'])->name('admin.service.store');
    Route::get('service/delete/{id}', [ServiceControllerForAdmin::class,'destroy']);
    Route::get('service/edit/{id}', [ServiceControllerForAdmin::class,'edit']);
    Route::post('service/update/{id}', [ServiceControllerForAdmin::class,'update']);

    Route::get('testimonial/view', [TestimonialController::class,'index'])->name('admin.testimonial.index');
    Route::get('testimonial/create', [TestimonialController::class,'create'])->name('admin.testimonial.create');
    Route::post('testimonial/store', [TestimonialController::class,'store'])->name('admin.testimonial.store');
    Route::get('testimonial/delete/{id}', [TestimonialController::class,'destroy']);
    Route::get('testimonial/edit/{id}', [TestimonialController::class,'edit']);
    Route::post('testimonial/update/{id}', [TestimonialController::class,'update']);

    Route::get('team-member/view', [TeamMemberControllerForAdmin::class,'index'])->name('admin.team_member.index');
    Route::get('team-member/create', [TeamMemberControllerForAdmin::class,'create'])->name('admin.team_member.create');
    Route::post('team-member/store', [TeamMemberControllerForAdmin::class,'store'])->name('admin.team_member.store');
    Route::get('team-member/delete/{id}', [TeamMemberControllerForAdmin::class,'destroy']);
    Route::get('team-member/edit/{id}', [TeamMemberControllerForAdmin::class,'edit']);
    Route::post('team-member/update/{id}', [TeamMemberControllerForAdmin::class,'update']);

    Route::get('job/view', [JobControllerForAdmin::class,'index'])->name('admin.job.index');
    Route::get('job/create', [JobControllerForAdmin::class,'create'])->name('admin.job.create');
    Route::post('job/store', [JobControllerForAdmin::class,'store'])->name('admin.job.store');
    Route::get('job/delete/{id}', [JobControllerForAdmin::class,'destroy']);
    Route::get('job/edit/{id}', [JobControllerForAdmin::class,'edit']);
    Route::post('job/update/{id}', [JobControllerForAdmin::class,'update']);
    Route::get('job/application', [JobControllerForAdmin::class,'view_application'])->name('admin.job.view_application');
    Route::get('job/application/delete/{id}', [JobControllerForAdmin::class,'delete_application']);

    Route::get('faq/view', [FaqControllerForAdmin::class,'index'])->name('admin.faq.index');
    Route::get('faq/create', [FaqControllerForAdmin::class,'create'])->name('admin.faq.create');
    Route::post('faq/store', [FaqControllerForAdmin::class,'store'])->name('admin.faq.store');
    Route::get('faq/delete/{id}', [FaqControllerForAdmin::class,'destroy']);
    Route::get('faq/edit/{id}', [FaqControllerForAdmin::class,'edit']);
    Route::post('faq/update/{id}', [FaqControllerForAdmin::class,'update']);

    Route::get('email-template/view', [EmailTemplateController::class,'index'])->name('admin.email_template.index');
    Route::get('email-template/edit/{id}', [EmailTemplateController::class,'edit']);
    Route::post('email-template/update/{id}', [EmailTemplateController::class,'update']);

    Route::get('social-media/view', [SocialMediaItemController::class,'index'])->name('admin.social_media.index');
    Route::get('social-media/create', [SocialMediaItemController::class,'create'])->name('admin.social_media.create');
    Route::post('social-media/store', [SocialMediaItemController::class,'store'])->name('admin.social_media.store');
    Route::get('social-media/delete/{id}', [SocialMediaItemController::class,'destroy']);
    Route::get('social-media/edit/{id}', [SocialMediaItemController::class,'edit']);
    Route::post('social-media/update/{id}', [SocialMediaItemController::class,'update']);

    Route::get('subscriber/view', [SubscriberController::class,'index'])->name('admin.subscriber.index');
    Route::get('subscriber/create', [SubscriberController::class,'create'])->name('admin.subscriber.create');
    Route::post('subscriber/store', [SubscriberController::class,'store'])->name('admin.subscriber.store');
    Route::get('subscriber/delete/{id}', [SubscriberController::class,'destroy']);
    Route::get('subscriber/send-email', [SubscriberController::class,'send_email'])->name('admin.subscriber.send_email');
    Route::post('subscriber/send-email-action', [SubscriberController::class,'send_email_action'])->name('admin.subscriber.send_email_action');

    Route::get('coupon/view', [CouponController::class,'index'])->name('admin.coupon.index');
    Route::get('coupon/create', [CouponController::class,'create'])->name('admin.coupon.create');
    Route::post('coupon/store', [CouponController::class,'store'])->name('admin.coupon.store');
    Route::get('coupon/delete/{id}', [CouponController::class,'destroy']);
    Route::get('coupon/edit/{id}', [CouponController::class,'edit']);
    Route::post('coupon/update/{id}', [CouponController::class,'update']);

    Route::get('shipping/view', [ShippingController::class,'index'])->name('admin.shipping.index');
    Route::get('shipping/create', [ShippingController::class,'create'])->name('admin.shipping.create');
    Route::post('shipping/store', [ShippingController::class,'store'])->name('admin.shipping.store');
    Route::get('shipping/delete/{id}', [ShippingController::class,'destroy']);
    Route::get('shipping/edit/{id}', [ShippingController::class,'edit']);
    Route::post('shipping/update/{id}', [ShippingController::class,'update']);

    Route::get('product/view', [ProductControllerForAdmin::class,'index'])->name('admin.product.index');
    Route::get('product/create', [ProductControllerForAdmin::class,'create'])->name('admin.product.create');
    Route::post('product/store', [ProductControllerForAdmin::class,'store'])->name('admin.product.store');
    Route::get('product/delete/{id}', [ProductControllerForAdmin::class,'destroy']);
    Route::get('product/edit/{id}', [ProductControllerForAdmin::class,'edit']);
    Route::post('product/update/{id}', [ProductControllerForAdmin::class,'update']);

    Route::get('order/view', [OrderControllerForAdmin::class,'index'])->name('admin.order.index');
    Route::get('order/create', [OrderControllerForAdmin::class,'create'])->name('admin.order.create');
    Route::post('order/store', [OrderControllerForAdmin::class,'store'])->name('admin.order.store');
    Route::get('order/detail/{id}', [OrderControllerForAdmin::class,'detail']);
    Route::get('order/invoice/{id}', [OrderControllerForAdmin::class,'invoice']);
    Route::get('order/delete/{id}', [OrderControllerForAdmin::class,'destroy']);

    Route::get('customer/view', [CustomerController::class,'index'])->name('admin.customer.index');
    Route::get('customer/detail/{id}', [CustomerController::class,'detail']);
    Route::get('customer/make-active/{id}', [CustomerController::class,'make_active']);
    Route::get('customer/make-pending/{id}', [CustomerController::class,'make_pending']);
    Route::get('customer/delete/{id}', [CustomerController::class,'destroy']);

    Route::get('footer/view', [FooterColumnController::class,'index'])->name('admin.footer.index');
    Route::get('footer/create', [FooterColumnController::class,'create'])->name('admin.footer.create');
    Route::post('footer/store', [FooterColumnController::class,'store'])->name('admin.footer.store');
    Route::get('footer/delete/{id}', [FooterColumnController::class,'destroy']);
    Route::get('footer/edit/{id}', [FooterColumnController::class,'edit']);
    Route::post('footer/update/{id}', [FooterColumnController::class,'update']);

    Route::get('menu/view', [MenuController::class,'index'])->name('admin.menu.index');
    Route::post('menu/update', [MenuController::class,'update']);

    Route::get('role/user', [RoleController::class,'user'])->name('admin.role.user');
    Route::get('role/user-create', [RoleController::class,'user_create'])->name('admin.role.user-create');
    Route::post('role/user-store', [RoleController::class,'user_store'])->name('admin.role.user-store');
    Route::get('role/user/edit/{id}', [RoleController::class,'user_edit']);
    Route::post('role/user/update/{id}', [RoleController::class,'user_update']);
    Route::get('role/user/edit/password/{id}', [RoleController::class,'user_edit_password']);
    Route::post('role/user/update/password/{id}', [RoleController::class,'user_update_password']);
    Route::get('role/user/delete/{id}', [RoleController::class,'user_destroy']);
    Route::get('role/index', [RoleController::class,'index'])->name('admin.role.index');
    Route::get('role/create', [RoleController::class,'create'])->name('admin.role.create');
    Route::post('role/store', [RoleController::class,'store'])->name('admin.role.store');
    Route::get('role/delete/{id}', [RoleController::class,'destroy']);
    Route::get('role/edit/{id}', [RoleController::class,'edit']);
    Route::post('role/update/{id}', [RoleController::class,'update']);
    Route::get('role/access-setup/{id}', [RoleController::class,'access_setup']);
    Route::post('role/access-setup-update/{id}', [RoleController::class,'access_setup_update']);

    Route::get('translation/front/edit', [TranslationController::class,'front_edit'])->name('admin.translation.front');
    Route::post('translation/front/update', [TranslationController::class,'front_update']);
});