<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
// pagination
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useBootstrap();

        $json_data = json_decode(file_get_contents(resource_path('lang/front.json')));
        foreach($json_data as $key=>$value) {
            define($key,$value);
        }

        if (empty(env('ASSET_URL'))) {
            config(['app.asset_url' => config('app.url') . '/public']);
        }
    }
}
